﻿
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_quotasreindex]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].[Sp_quotasreindex]
GO


CREATE PROCEDURE [dbo].[Sp_quotasreindex]
                @ProjectId INT,
                @userId    INT
AS   

    CREATE TABLE #respondentsToBlock
    (
    respondentid VARCHAR(10) primary key
    ) 

    CREATE TABLE #respondentsToBlockBatch
    (
    respondentid VARCHAR(10) primary key
    ) 
 
    CREATE TABLE #respondentsToUnblock
    (
    respondentid VARCHAR(10) primary key
    )

    CREATE TABLE #respondentsToUnblockBatch
    (
    respondentid VARCHAR(10) primary key
    )
 
    INSERT INTO #respondentsToBlock
    SELECT resrespondent from respondent  r WITH(NOLOCK)    
    WHERE r.ResBlocked = 0 AND EXISTS  (SELECT 1
	FROM   Quota q with(nolock) INNER JOIN Stratum s WITH(NOLOCK) ON q.QtQuotaId = s.StrQuotaId
	WHERE  q.QtStatus = 2 and s.StrRespondent = ResRespondent)
 
    INSERT INTO #respondentsToUnblock
    SELECT resrespondent from respondent  r WITH(NOLOCK)    
    WHERE r.ResBlocked = 1 AND NOT EXISTS  (SELECT 1
	FROM   Quota q with(nolock) INNER JOIN Stratum s WITH(NOLOCK) ON q.QtQuotaId = s.StrQuotaId
	WHERE  q.QtStatus = 2 and s.StrRespondent = ResRespondent)
 
    DECLARE @BatchSize INT
    SET @BatchSize = 4000

    /* Disable dialing for cases that ARE currently not blocked and ARE found in any closed strata */
    WHILE EXISTS (SELECT 1 FROM #respondentsToBlock)
    BEGIN
        DELETE TOP (@BatchSize)
        FROM #respondentsToBlock
        OUTPUT deleted.respondentid INTO #respondentsToBlockBatch  

        UPDATE Respondent 
        SET ResBlocked = 1,
            ProjectId = @ProjectId,
            ModifiedBy = @UserId,
            Modified = Getutcdate()
        WHERE resrespondent IN (SELECT respondentid FROM #respondentsToBlockBatch)

        TRUNCATE TABLE #respondentsToBlockBatch;
    END                                        

	/* Enable dialing for cases that ARE currently blocked and ARE NOT found in any closed strata */
    WHILE EXISTS (SELECT 1 FROM #respondentsToUnblock)
    BEGIN
        DELETE TOP (@BatchSize)
        FROM #respondentsToUnblock
        OUTPUT deleted.respondentid INTO #respondentsToUnblockBatch 

        UPDATE Respondent 
        SET ResBlocked = 0,
            ProjectId = @ProjectId,
            ModifiedBy = @UserId,
            Modified = Getutcdate()
        WHERE resrespondent IN (SELECT respondentid FROM #respondentsToUnblockBatch)

        TRUNCATE TABLE #respondentsToUnblockBatch;
    END                                        

	DROP TABLE #respondentsToBlock
    DROP TABLE #respondentsToBlockBatch
	DROP TABLE #respondentsToUnblock
    DROP TABLE #respondentsToUnblockBatch
